/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.access.api.AcaClient;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.AccUtils;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.websm.user.SetPassword;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import com.ibm.websm.etc.StringVector;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class PIUserUtils {
    public static final String HMC_GROUP = "hmc";
    public static final String S_HMC_USER_DEF_AGE_STR = "99999";
    public static final int S_HMC_USER_DEF_AGE_INT = 99999;
    public static final String ERROR_EXCEPTION = "_ErrorException";
    public static final String ERROR_TEXT = "_ErrorText";
    public static final String ERROR_TITLE = "_ErrorTitle";
    public static final String ERROR_DISPOSE = "_ErrorDispose";
    public static final String PASSWD_PROP = "_Passwd_PROP";
    public static final String RETYPE_PASSWD_PROP = "_RePasswd_PROP";
    public static final String USER_NAME_PROP = "_Name_PROP";
    public static final String USER_UID_PROP = "_UID_PROP";
    public static final String USER_DESC_PROP = "_Descrp_PROP";
    public static final String USER_PWX_PROP = "_PasswdX_PROP";
    public static final String HMC_USER = "HMC User";
    public static final String HMC_SUPER_USER = "HMC Super User";
    public static final String TYPE_TASKROLE = "taskrole";
    public static final String TYPE_DESC = "desc";
    public static final String TYPE_DESCRIPTION = "description";
    public static final String TYPE_PASSWORD = "passwd";
    public static final String TYPE_PWAGE = "pwage";
    public static final String TYPE_NAME = "name";
    public static final String TYPE_ASSIGNMENT = "assign";
    public static final String TYPE_RESOURCE = "resource";
    public static final String TYPE_RESOURCES = "resources";
    public static final String TYPE_RSRCROLE = "resourcerole";
    private static final String CMD_HSCUSERCONF = "/opt/hsc/bin/HSCUserConf ";
    private static final String CMD_GETUSERLIST = "/opt/hsc/bin/getUserList ";

    private static boolean isFirstCharAlpha(String string) {
        String string2 = string.substring(0, 1);
        return string2.matches("[a-z].*") || string2.matches("[A-Z].*");
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() <= 0;
    }

    private static String getPasswdIllegalCharacters() {
        String string = "\\ ' \" > / $";
        return string;
    }

    private static String getUserNameIllegalCharacters() {
        String string = "\\ < > * & ? $ | [ ] ' ` \" , ~ : ( ) ; ! # % ^ = / + @ { }";
        return string;
    }

    private static boolean containsInvalidCharacter(String string) {
        String string2 = PIUserUtils.getUserNameIllegalCharacters();
        string = string.trim();
        for (int i = 0; i < string.length(); ++i) {
            if (string2.indexOf(string.charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    private static boolean containsInvalidPasswdCharacter(String string) {
        String string2 = PIUserUtils.getPasswdIllegalCharacters();
        string = string.trim();
        for (int i = 0; i < string.length(); ++i) {
            if (string2.indexOf(string.charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    public static String isValidUserDescription(String string) throws PIHscClientException {
        string = string.replace(',', ' ');
        string = string.replace('#', ' ');
        string = string.replace('$', ' ');
        string = string.replace(':', ' ');
        string = string.replace('!', ' ');
        string = string.replace('~', ' ');
        string = string.replace('<', ' ');
        string = string.replace('>', ' ');
        string = string.replace('\'', ' ');
        return string;
    }

    private static boolean confirmPassword(String string, String string2) {
        if (string == null || string2 == null || string.trim().length() == 0 || string2.trim().length() == 0) {
            return false;
        }
        try {
            if (!PIUserUtils.isHMCUser(string)) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        StringBuffer stringBuffer = PIUserUtils.parsePassword(string2);
        String string3 = "/opt/hsc/bin/HSCUserConf -o " + stringBuffer + " " + string;
        EExecResult eExecResult = EExec.Exec((String)string3);
        PIUserUtils.printExecResult(eExecResult);
        if (eExecResult.rc == 0) {
            AccUtils.DBG("authentication success");
            return true;
        }
        AccUtils.DBG("authenticate : failed");
        return false;
    }

    private static StringBuffer parsePassword(String string) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer("");
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '\\') {
                stringBuffer.append(c);
                stringBuffer.append(c);
                stringBuffer.append(c);
            } else if (c == '`' || c == '$' || c == '\"' || c == '\'' || c == ';' || c == '|' || c == '<' || c == '>' || c == '(' || c == ')' || c == '&') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            c = stringCharacterIterator.next();
        }
        return stringBuffer;
    }

    private static void throwGetUserPropertyException(String string) throws PIHscClientException {
        String[] stringArray = new String[]{string};
        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "USER_GETTING_PROPERTY_ERROR", stringArray, new Throwable());
    }

    public static boolean isHMCSuperUser(String string) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        return "hscroot".equals(string.trim()) || string.trim().equals("root");
    }

    public static boolean isHMCSuperUser() {
        String string = System.getProperty("HMCRealUser.name");
        return PIUserUtils.isHMCSuperUser(string);
    }

    public static String[] getUserRoles(String string) {
        String[] stringArray = new String[1];
        if (string == null || string.length() == 0) {
            return stringArray;
        }
        try {
            AcaClient acaClient = new AcaClient(1);
            stringArray = acaClient.GetRoles(string);
            if (stringArray == null) {
                stringArray = new String[1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    public static boolean isHMCUser(String string) {
        String string2 = string.trim();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        StringVector stringVector = PIUserUtils.getUserList();
        if (stringVector == null) {
            AccUtils.SHOW("ERROR: getUserList return null!");
            return false;
        }
        boolean bl = false;
        Enumeration enumeration = stringVector.elements();
        while (enumeration.hasMoreElements()) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)enumeration.nextElement(), ":");
            String string6 = stringTokenizer.nextToken();
            if (!string2.equals(string6)) continue;
            bl = true;
            String string7 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) break;
            string4 = stringTokenizer.nextToken();
            break;
        }
        return bl;
    }

    public static Vector getHMCUsers() throws PIHscClientException {
        String string = "";
        Vector<String> vector = new Vector<String>();
        AccUtils.DBG("... getHMCUsers");
        EExecResult eExecResult = EExec.Exec((String)"/opt/hsc/bin/getUserList -list");
        if (eExecResult.rc != 0) {
            return null;
        }
        String string2 = eExecResult.stdout;
        if (string2.trim().length() > 0) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2 == null) {
            PIUserUtils.throwGetUserPropertyException("all");
        }
        boolean bl = true;
        while (bl) {
            String string3 = string2.substring(0, string2.indexOf(","));
            vector.add(string3);
            if ((string2 = string2.substring(string2.indexOf(",") + 1, string2.length())) != null && string2.length() > 5) continue;
            bl = false;
        }
        vector.trimToSize();
        return vector;
    }

    public static boolean getHMCUserProperties(String string, Hashtable hashtable) throws PIHscClientException {
        String string2 = string.trim();
        String string3 = "";
        String string4 = "";
        StringVector stringVector = PIUserUtils.getUserList();
        if (stringVector == null) {
            PIUserUtils.throwGetUserPropertyException(string2);
        }
        boolean bl = false;
        Enumeration enumeration = stringVector.elements();
        while (enumeration.hasMoreElements()) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)enumeration.nextElement(), ":");
            string3 = stringTokenizer.nextToken();
            if (!string2.equals(string3)) continue;
            bl = true;
            hashtable.put(USER_NAME_PROP, string3);
            hashtable.put(USER_PWX_PROP, stringTokenizer.nextToken());
            hashtable.put(USER_UID_PROP, stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) break;
            hashtable.put(USER_DESC_PROP, stringTokenizer.nextToken());
            break;
        }
        return bl;
    }

    public static boolean isUserExist(String string) {
        String string2 = string.trim();
        EExecResult eExecResult = EExec.Exec((String)("grep -c -w " + string2 + " /etc/passwd | cut -f 1 -d:"));
        if (IDebug.enabled) {
            IDebug.println((String)("grep count of " + string2 + " is " + eExecResult.stdout));
        }
        if (eExecResult.stdout != null) {
            String string3 = eExecResult.stdout;
            if (!string3.trim().equals("0")) {
                EExecResult eExecResult2 = EExec.Exec((String)("grep  " + string2 + " /etc/passwd | cut -f 1 -d:"));
                if (eExecResult2.stdout != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(eExecResult2.stdout, "\n");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        if (!string4.trim().equals(string2)) continue;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public static void validateLogin(String string) throws PIHscClientException {
        AccUtils.DBG("Enter validateLogin " + string);
        if (PIUserUtils.isEmpty(string)) {
            throw new PIHscClientException("2338", "PIHscCmdLineBundle", "USER_NAME_REQUIRED");
        }
        if ((string = string.trim()).length() > 32) {
            throw new PIHscClientException("232B", "PIHscCmdLineBundle", "USER_SHOULDNOT_30_CHRS");
        }
        if (PIUserUtils.containsInvalidCharacter(string) || !PIUserUtils.isFirstCharAlpha(string)) {
            String[] stringArray = new String[]{PIUserUtils.getUserNameIllegalCharacters()};
            throw new PIHscClientException("2329", "PIHscCmdLineBundle", "USER_INVALID_USER_NAME", stringArray, new Throwable());
        }
    }

    public static void validateUserPassword(String string, String string2) throws PIHscClientException {
        if (!PIUserUtils.confirmPassword(string, string2)) {
            throw new PIHscClientException("233B", "PIHscCmdLineBundle", "USER_BAD_OLD_PASSWORD");
        }
    }

    public static void validatePasswordInput(String string, String string2, String string3) throws PIHscClientException {
        AccUtils.DBG("In validatePasswordInput " + string);
        String string4 = string2.trim();
        String string5 = string3.trim();
        String string6 = string.trim();
        if (string4 == null || string4.length() <= 0 || string5 == null || string5.length() <= 0 || string6 == null || string6.length() <= 0) {
            int n = PIUserUtils.getMinPwdLength();
            String[] stringArray = new String[]{Integer.toString(n)};
            throw new PIHscClientException("2339", "PIHscCmdLineBundle", "USER_EMPTY_PASSWORD", stringArray, new Throwable());
        }
        if (!string4.equals(string5)) {
            throw new PIHscClientException("2330", "PIHscCmdLineBundle", "USER_BAD_PASSWORD");
        }
        PIUserUtils.validatePasswordInput(string4, true);
    }

    public static void validatePasswordInput(String string, boolean bl) throws PIHscClientException {
        AccUtils.DBG("In validatePasswordInput ");
        String string2 = PIUserUtils.getPasswdIllegalCharacters();
        int n = PIUserUtils.getMinPwdLength();
        String[] stringArray = new String[]{Integer.toString(n), string2};
        if (string == null || PIUserUtils.containsInvalidPasswdCharacter(string)) {
            AccUtils.DBG("Null - validatePasswordInput " + string);
            throw new PIHscClientException("2339", "PIHscCmdLineBundle", "USER_EMPTY_PASSWORD", stringArray, new Throwable());
        }
        if (bl && string.length() < n) {
            AccUtils.DBG("short passwd - " + string + " - need " + n);
            EExec.Exec((String)"env > /tmp/HCM.env");
            throw new PIHscClientException("2339", "PIHscCmdLineBundle", "USER_EMPTY_PASSWORD", stringArray, new Throwable());
        }
    }

    public static StringVector getUserList() {
        StringVector stringVector = new StringVector();
        EExecResult eExecResult = EExec.Exec((String)"/opt/hsc/bin/getUserList -list");
        if (eExecResult.rc != 0) {
            return null;
        }
        if (eExecResult.stdout != null) {
            String string = eExecResult.stdout;
            if (string.trim().length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                stringVector.addElement((String)stringTokenizer.nextElement());
            }
        }
        return stringVector;
    }

    public static void logSysEvent(short s, String[] stringArray) {
        String string;
        String string2 = System.getProperty("HMCRealUser.name");
        if (stringArray.length < 2) {
            stringArray = new String[]{"unknown", "undefined"};
        }
        switch (s) {
            case 2108: {
                string = "HSCE2108 User name " + string2 + ": Failed to remove user " + stringArray;
                break;
            }
            case 2107: {
                string = "HSCE2107 User name " + string2 + ": Removed user " + stringArray[0];
                break;
            }
            case 2101: {
                string = "HSCE2101 User name " + string2 + ": Created user " + stringArray[0] + " with role " + stringArray[1];
                break;
            }
            case 2102: {
                string = "HSCE2102 User name " + string2 + ": Failed to create user " + stringArray[0] + " with role " + stringArray[1];
                break;
            }
            case 2104: {
                string = "HSCE2104 User name " + string2 + ": Failed to change properties of user " + stringArray[0];
                break;
            }
            case 2105: {
                string = "HSCE2103 User name " + string2 + ": Changed properties of user " + stringArray[0] + " new name " + stringArray[1] + " new role " + stringArray[2];
                break;
            }
            case 2103: {
                string = "HSCE2105 User name " + string2 + ": Changed password of user " + stringArray[0];
                break;
            }
            case 2106: {
                string = "HSCE2106 User name " + string2 + ": Failed to change password of user " + stringArray[0];
            }
            default: {
                string = "Unknown User op" + string2;
            }
        }
        HSCLogUtils.logSystemEvent(s, string, stringArray, string2);
    }

    public static String buildDeleteCmd(String string) {
        return "/opt/hsc/bin/HSCUserConf -d " + string;
    }

    public static void setPasswdExpiration(String string, String string2) {
        String string3 = "/opt/hsc/bin/HSCUserConf -x -M " + string2 + " " + string;
        EExecResult eExecResult = EExec.Exec((String)string3);
        PIUserUtils.printExecResult(eExecResult);
    }

    public static String buildModifyEncrptPasswd(String string, String string2) {
        SetPassword setPassword = new SetPassword(string, string2);
        String string3 = setPassword.encryptPW(string2);
        StringBuffer stringBuffer = PIUserUtils.parsePassword(string3);
        String string4 = "/opt/hsc/bin/HSCUserConf -e " + stringBuffer.toString() + " " + string;
        return string4;
    }

    public static String buildStorePasswdCmd(String string, String string2) {
        String string3 = null;
        StringBuffer stringBuffer = PIUserUtils.parsePassword(string2);
        if ("hscroot".equals(string)) {
            string3 = "/opt/hsc/bin/HSCUserConf -s " + stringBuffer + " " + string;
        }
        return string3;
    }

    public static void storePasswdIfHscroot(String string, String string2) throws PIHscClientException {
        if ("hscroot".equals(string)) {
            String string3 = PIUserUtils.buildStorePasswdCmd(string, string2);
            EExecResult eExecResult = EExec.Exec((String)string3);
            PIUserUtils.printExecResult(eExecResult);
            if (eExecResult.rc != 0) {
                throw new PIHscClientException("2331", "PIHscCmdLineBundle", "2331");
            }
        }
    }

    public static String[] getRolesArray(String[] stringArray) {
        return PIUserUtils.getRolesArray(stringArray, false);
    }

    public static String[] getRolesArray(String[] stringArray, boolean bl) {
        String[] stringArray2 = new String[stringArray.length];
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = PIUserUtils.getRoleDescription(stringArray[i], bl);
            }
        }
        return stringArray2;
    }

    public static String buildModifyCmd(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2) {
        int n;
        String string5 = "/opt/hsc/bin/HSCUserConf  -m ";
        if (string != null && string.length() > 0) {
            string5 = string5 + " -l " + string + " ";
        }
        if (string4 != null && string4.length() > 0) {
            string5 = string5 + " -name '" + string4 + "'";
        }
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                string5 = string5 + " -role " + stringArray[n];
            }
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                string5 = string5 + " -G " + stringArray2[n];
            }
        }
        if (string3 != null && string3.length() > 0) {
            string5 = string5 + " -p " + string3;
        }
        string5 = string5 + " " + string2;
        return string5;
    }

    public static String buildCreateCmd(String string, String string2, String[] stringArray, String[] stringArray2) {
        int n;
        String string3 = "/opt/hsc/bin/HSCUserConf -c " + string;
        if (string2.trim().length() > 0) {
            string3 = string3 + " -name '" + string2.trim() + "'";
        }
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                string3 = string3 + " -role " + stringArray[n];
            }
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                string3 = string3 + " -G " + stringArray2[n];
            }
        }
        return string3;
    }

    public static String getRoleDescription(String string, boolean bl) {
        return string;
    }

    public static Hashtable getUserProperties(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (string != null) {
            AccUtils.DBG("getUserProperties - " + string);
            string2 = string.substring(0, string.indexOf(":"));
            string5 = string.substring(string.indexOf(":") + 1, string.length());
            string4 = string5.substring(0, string5.indexOf(":"));
            string3 = string5.substring(string5.indexOf(":") + 1, string5.length());
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("_loginName", string2);
            hashtable.put("_fullName", string3);
            hashtable.put("_id", string4);
            return hashtable;
        }
        return null;
    }

    public static Hashtable getHscGroups(String string) {
        if (string == null) {
            return null;
        }
        EExecResult eExecResult = EExec.Exec((String)("/opt/hsc/bin/getUserList -userroles " + string));
        if (eExecResult.stdout != null) {
            Object object;
            String string2 = eExecResult.stdout;
            String string3 = string2.substring(0, string2.indexOf("~"));
            String string4 = string2.substring(string2.indexOf("~") + 1, string2.length());
            String string5 = string4.substring(0, string4.indexOf("~"));
            String string6 = string4.substring(string4.indexOf("~") + 1, string4.length());
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "\n");
            if (stringTokenizer.countTokens() > 0) {
                object = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    object[n] = stringTokenizer.nextToken();
                    ++n;
                }
                hashtable.put("roleList", object);
            }
            if (((StringTokenizer)(object = new StringTokenizer(string5, "\n"))).countTokens() > 0) {
                String[] stringArray = new String[((StringTokenizer)object).countTokens()];
                int n = 0;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    stringArray[n] = ((StringTokenizer)object).nextToken();
                    ++n;
                }
                hashtable.put("roleDesc", stringArray);
            }
            hashtable.put("userProp", PIUserUtils.getUserProperties(string6));
            return hashtable;
        }
        return null;
    }

    public static boolean getUserPassword(String string, Hashtable hashtable) {
        hashtable.clear();
        try {
            EExecResult eExecResult;
            String string2 = System.getProperty("HMCtty.name");
            String string3 = null;
            String string4 = null;
            boolean bl = false;
            if (string2 != null && string2 != "") {
                eExecResult = EExec.Exec((String)("stty --save --file=" + string2));
                string3 = "stty --file=" + string2 + " " + eExecResult.stdout;
                string4 = "stty --file=" + string2 + " -echo";
                bl = true;
            }
            Object[] objectArray = new String[]{string};
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "ENTER_NEW_PASSWORD", null, objectArray));
            if (bl) {
                eExecResult = EExec.Exec(string4);
            }
            String string5 = bufferedReader.readLine().trim();
            if (bl) {
                eExecResult = EExec.Exec((String)string3);
            }
            AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "REENTER_NEW_PASSWORD", null, objectArray));
            if (bl) {
                eExecResult = EExec.Exec((String)string4);
            }
            String string6 = bufferedReader.readLine().trim();
            if (bl) {
                eExecResult = EExec.Exec((String)string3);
            }
            bufferedReader.close();
            hashtable.put(PASSWD_PROP, string5);
            hashtable.put(RETYPE_PASSWD_PROP, string6);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String arrayToString(String[] stringArray) {
        String string = "";
        if (stringArray == null) {
            return string;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            if (i + 1 < stringArray.length) {
                string = string + ", ";
            }
            if (i + 2 != stringArray.length) continue;
            string = string + "and ";
        }
        return string;
    }

    public static String arrayToString(String[] stringArray, String string) {
        String string2 = "";
        if (stringArray == null) {
            return string2;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + stringArray[i];
            if (i + 1 >= stringArray.length) continue;
            string2 = string2 + string;
        }
        return string2;
    }

    public static void printExecResult(EExecResult eExecResult) {
        File file = new File("/var/hsc/log/.DEBUG_ACM");
        if (file.exists()) {
            AccUtils.DBG("Exec RC =" + eExecResult.rc);
            AccUtils.DBG("Exec stdout =" + eExecResult.stdout);
            AccUtils.DBG("Exec stderr =" + eExecResult.stderr);
        }
    }

    public static int getPwdExpirationDays(String string) {
        int n = PIUserUtils.getMaxPwdExpirationDays();
        EExecResult eExecResult = EExec.Exec((String)("/opt/hsc/bin/HSCUserConf -q pwexp " + string));
        if (eExecResult.rc == 0 && eExecResult.stdout != null) {
            try {
                n = Integer.parseInt(eExecResult.stdout.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public static int getMinPwdLength() {
        int n = 7;
        EExecResult eExecResult = EExec.Exec((String)"/opt/hsc/bin/HSCUserConf -q minpwl");
        if (eExecResult.rc == 0 && eExecResult.stdout != null) {
            try {
                n = Integer.parseInt(eExecResult.stdout.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public static int getMaxPwdExpirationDays() {
        int n = 180;
        EExecResult eExecResult = EExec.Exec((String)"/opt/hsc/bin/HSCUserConf -q maxpwd");
        if (eExecResult.rc == 0 && eExecResult.stdout != null) {
            try {
                n = Integer.parseInt(eExecResult.stdout.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public static boolean isValidPasswordAge(String string) {
        Integer n = null;
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return n >= 0 && n <= 99999;
    }

    public static boolean isHmcSuperUser(String string) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        return string.equals("root") || "hscroot".equals(string);
    }
}

